/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.ValidItemsScreen;
import dev.ftb.mods.ftbquests.integration.jei.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTask
extends Task
implements Predicate<ItemStack> {
    public ItemStack item = ItemStack.field_190927_a;
    public long count = 1L;
    public Tristate consumeItems = Tristate.DEFAULT;
    public Tristate onlyFromCrafting = Tristate.DEFAULT;

    public ItemTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        NBTUtils.write(nbt, "item", this.item);
        if (this.count > 1L) {
            nbt.func_74772_a("count", this.count);
        }
        this.consumeItems.write(nbt, "consume_items");
        this.onlyFromCrafting.write(nbt, "only_from_crafting");
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.item = NBTUtils.read(nbt, "item");
        this.count = Math.max(nbt.func_74763_f("count"), 1L);
        this.consumeItems = Tristate.read((CompoundNBT)nbt, (String)"consume_items");
        this.onlyFromCrafting = Tristate.read((CompoundNBT)nbt, (String)"only_from_crafting");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (this.count > 1L ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (this.consumeItems != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.consumeItems == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.onlyFromCrafting != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (this.onlyFromCrafting == Tristate.TRUE ? 1 : 0) != 0);
        buffer.func_150787_b(flags);
        FTBQuestsNetHandler.writeItemType(buffer, this.item);
        if (this.count > 1L) {
            buffer.func_179254_b(this.count);
        }
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        int flags = buffer.func_150792_a();
        this.item = FTBQuestsNetHandler.readItemType(buffer);
        long l = this.count = Bits.getFlag((int)flags, (int)1) ? buffer.func_179260_f() : 1L;
        Tristate tristate = Bits.getFlag((int)flags, (int)2) ? (Bits.getFlag((int)flags, (int)4) ? Tristate.TRUE : Tristate.FALSE) : (this.consumeItems = Tristate.DEFAULT);
        this.onlyFromCrafting = Bits.getFlag((int)flags, (int)8) ? (Bits.getFlag((int)flags, (int)16) ? Tristate.TRUE : Tristate.FALSE) : Tristate.DEFAULT;
    }

    public List<ItemStack> getValidDisplayItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemFiltersAPI.getDisplayItemStacks((ItemStack)this.item, list);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        if (this.count > 1L) {
            return new StringTextComponent(this.count + "x ").func_230529_a_(this.item.func_200301_q());
        }
        return new StringTextComponent("").func_230529_a_(this.item.func_200301_q());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : this.getValidDisplayItems()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            Icon icon = ItemIcon.getItemIcon((ItemStack)copy);
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public boolean test(ItemStack stack) {
        return ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.field_190927_a, true, false).setNameKey("ftbquests.task.ftbquests.item");
        config.addLong("count", this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", (Object)this.consumeItems, v -> {
            this.consumeItems = v;
        }, Tristate.NAME_MAP);
        config.addEnum("only_from_crafting", (Object)this.onlyFromCrafting, v -> {
            this.onlyFromCrafting = v;
        }, Tristate.NAME_MAP);
    }

    @Override
    public boolean consumesResources() {
        return this.consumeItems.get(this.quest.chapter.file.defaultTeamConsumeItems);
    }

    @Override
    public boolean canInsertItem() {
        return this.consumesResources();
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.consumesResources();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        List<ItemStack> validItems = this.getValidDisplayItems();
        if (!this.consumesResources() && validItems.size() == 1 && Platform.isModLoaded((String)"jei")) {
            this.showJEIRecipe(validItems.get(0));
        } else if (validItems.isEmpty()) {
            Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new CustomToast((ITextComponent)new StringTextComponent("No valid items!"), ItemIcon.getItemIcon((Item)((Item)FTBQuestsItems.MISSING_ITEM.get())), (ITextComponent)new StringTextComponent("Report this bug to modpack author!")));
        } else {
            new ValidItemsScreen(this, validItems, canClick).openGui();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showJEIRecipe(ItemStack stack) {
        FTBQuestsJEIHelper.showRecipes(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        if (this.consumesResources()) {
            list.blankLine();
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.task.click_to_submit").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE}));
        } else if (this.getValidDisplayItems().size() > 1) {
            list.blankLine();
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.task.ftbquests.item.view_items").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE}));
        } else if (Platform.isModLoaded((String)"jei")) {
            list.blankLine();
            list.add((ITextComponent)new TranslationTextComponent("ftbquests.task.ftbquests.item.click_recipe").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE}));
        }
    }

    public ItemStack insert(TeamData teamData, ItemStack stack, boolean simulate) {
        long add;
        if (!teamData.isCompleted(this) && this.test(stack) && (add = Math.min((long)stack.func_190916_E(), this.count - teamData.getProgress(this))) > 0L) {
            if (!simulate && teamData.file.isServerSide()) {
                teamData.addProgress(this, add);
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e((int)((long)stack.func_190916_E() - add));
            return copy;
        }
        return stack;
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayerEntity player, ItemStack craftedItem) {
        if (teamData.isCompleted(this) || this.item.func_77973_b() instanceof MissingItem || craftedItem.func_77973_b() instanceof MissingItem) {
            return;
        }
        if (!this.consumesResources()) {
            if (this.onlyFromCrafting.get(false)) {
                if (!craftedItem.func_190926_b() && this.test(craftedItem)) {
                    teamData.addProgress(this, craftedItem.func_190916_E());
                }
                return;
            }
            long c = 0L;
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack.func_190926_b() || !this.test(stack)) continue;
                c += (long)stack.func_190916_E();
            }
            if ((c = Math.min(this.count, c)) > teamData.getProgress(this)) {
                teamData.setProgress(this, c);
                return;
            }
            return;
        }
        if (!craftedItem.func_190926_b()) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack1;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack == (stack1 = this.insert(teamData, stack, false))) continue;
            changed = true;
            player.field_71071_by.field_70462_a.set(i, (Object)(stack1.func_190926_b() ? ItemStack.field_190927_a : stack1));
        }
        if (changed) {
            player.field_71071_by.func_70296_d();
            player.field_71070_bA.func_75142_b();
        }
    }
}

